/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.fan_types;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import dev.lopyluna.dndesires.register.DesiresRecipeTypes;
import dev.lopyluna.dndesires.register.DesiresTags;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FreezingType
implements FanProcessingType {
    public boolean isValidAt(Level level, BlockPos pos) {
        FluidState fluidState = level.getFluidState(pos);
        if (DesiresTags.FluidTags.FAN_PROCESSING_CATALYSTS_FREEZING.is(fluidState)) {
            return true;
        }
        BlockState blockState = level.getBlockState(pos);
        return DesiresTags.BlockTags.FAN_PROCESSING_CATALYSTS_FREEZING.is(blockState);
    }

    public int getPriority() {
        return 1100;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        return DesiresRecipeTypes.FREEZING.find(new SingleRecipeInput(stack), level).isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        return DesiresRecipeTypes.FREEZING.find(new SingleRecipeInput(stack), level).map(recipeRecipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (RecipeHolder)recipeRecipeHolder)).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(8) != 0) {
            return;
        }
        Vector3f color = new Color(14543103).asVectorF();
        level.addParticle((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        particleAccess.setColor(Color.mixColors((int)0xEEEEFF, (int)14543103, (float)random.nextFloat()));
        particleAccess.setAlpha(1.0f);
        if (random.nextFloat() < 0.0078125f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, 0.125f);
        }
        if (random.nextFloat() < 0.03125f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.POOF, 0.125f);
        }
    }

    public void affectEntity(Entity entity, Level level) {
        entity.setIsInPowderSnow(true);
        if (level.isClientSide) {
            return;
        }
        if (entity.canFreeze()) {
            int i = entity.getTicksFrozen();
            entity.setTicksFrozen(Math.min(entity.getTicksRequiredToFreeze() + 3, i + 3));
        }
        if (entity instanceof EnderMan || entity instanceof Blaze) {
            entity.hurt(entity.damageSources().freeze(), 8.0f);
        }
        if (entity.isOnFire()) {
            entity.clearFire();
            level.playSound(null, entity.blockPosition(), SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.NEUTRAL, 0.7f, 1.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
        }
    }
}

